<?php
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache, must-revalidate');
date_default_timezone_set('Asia/Dhaka');

include 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);
    exit;
}

$name = trim($_POST["name"] ?? '');
$email = trim($_POST["email"] ?? '');
$password = trim($_POST["password"] ?? '');
$method = trim($_POST["method"] ?? '');
$trxid = trim($_POST["trxid"] ?? '');
$date = date("d-M-Y");
$time = date("h:i:s A");

if ($email === '' || $password === '' || $method === '' || $trxid === '') {
    echo json_encode(["status" => "error", "message" => "Missing Parameters"], JSON_PRETTY_PRINT);
    exit;
}


$user_stmt = $conn->prepare("SELECT 1 FROM users WHERE email = ? AND password = ?");
$user_stmt->bind_param("ss", $email, $password);
$user_stmt->execute();
$user_result = $user_stmt->get_result();

if ($user_result->num_rows === 0) {
    http_response_code(403);
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);
    $user_stmt->close();
    $conn->close();
    exit;
}
$user_stmt->close();

$method_up = strtoupper($method);
if (!in_array($method_up, ['BKASH', 'NAGAD'])) {
    echo json_encode(["status" => "error", "message" => "Invalid Payment Method"], JSON_PRETTY_PRINT);
    exit;
}

$stmt = $conn->prepare("SELECT * FROM rs_sms WHERE sender = ? AND message LIKE ?");
$search = "%$trxid%";
$stmt->bind_param("ss", $method, $search);
$stmt->execute();
$result = $stmt->get_result();

$foundRow = null;
$found_txn = null;
$amount = 0.00;
$sender_number = null;

while ($row = $result->fetch_assoc()) {
    $message = $row['message'];
    $candidate_txn = null;
    $candidate_amount = null;
    $candidate_number = null;

    if ($method_up === 'NAGAD') {
        
        if (preg_match('/TxnID[:\s]*([A-Z0-9]+)/i', $message, $m_txn)) {
            $candidate_txn = $m_txn[1];
        }
        
        if (preg_match('/Amount[:\s]*Tk\s*([\d,\.]+)/i', $message, $m_amt)) {
            $candidate_amount = floatval(str_replace(',', '', $m_amt[1]));
        }
       
        if (preg_match('/Sender[:\s]*0\d{10}/i', $message, $m_num)) {
            $candidate_number = trim($m_num[0]);
            $candidate_number = str_replace(['Sender:', ' '], '', $candidate_number);
        }
    } elseif ($method_up === 'BKASH') {
        
        if (preg_match('/TrxID[:\s]*([A-Z0-9]+)/i', $message, $m_txn)) {
            $candidate_txn = $m_txn[1];
        }
        
        if (preg_match('/You have received\s*Tk\s*([\d,\.]+)/i', $message, $m_amt)) {
            $candidate_amount = floatval(str_replace(',', '', $m_amt[1]));
        }
        
        if (preg_match('/from\s*(0\d{10})/i', $message, $m_num)) {
            $candidate_number = $m_num[1];
        }
    }

    if ($candidate_txn !== null && strcasecmp($candidate_txn, $trxid) === 0) {
        $foundRow = $row;
        $found_txn = $candidate_txn;
        if ($candidate_amount !== null) $amount = $candidate_amount;
        if ($candidate_number !== null) $sender_number = $candidate_number;
        break;
    }
}

if ($foundRow === null) {
    echo json_encode(["status" => "error", "message" => "Transaction Not Found"], JSON_PRETTY_PRINT);
    exit;
}

if ($foundRow['status'] === 'success') {
    echo json_encode(["status" => "error", "message" => "Transaction ID Already Used"], JSON_PRETTY_PRINT);
    exit;
}

if ($sender_number === null || $sender_number === '') {
    $sender_number = $foundRow['number'] ?? '';
}

if ($sender_number === null || $sender_number === '') {
    echo json_encode(["status" => "error", "message" => "Sender number not found"], JSON_PRETTY_PRINT);
    exit;
}

$update = $conn->prepare("UPDATE rs_sms SET status = 'success' WHERE id = ?");
$update->bind_param("i", $foundRow['id']);
$update->execute();

$insert = $conn->prepare("INSERT INTO addmoney (name, email, method, number, amount, trxid, status, date, time)
VALUES (?, ?, ?, ?, ?, ?, 'Success', ?, ?)");
$insert->bind_param("ssssssss", $name, $email, $method_up, $sender_number, $amount, $trxid, $date, $time);

$update2 = $conn->prepare("UPDATE users SET balance = balance + ? WHERE email = ?");
$update2->bind_param("ds", $amount, $email);

if ($insert->execute() && $update2->execute()) {
    echo json_encode([
        "status" => "success",
        "message" => "Add Money Successful",
        "method" => $method_up,
        "transaction_id" => $found_txn,
        "amount" => intval($amount),
        "sender_number" => $sender_number
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode(["status" => "error", "message" => "Add Money Failed"], JSON_PRETTY_PRINT);
}

$conn->close();
?>