<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid Request Method"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

if (!isset($_POST['email'], $_POST['password'])) {
    echo json_encode(["status" => "error", "message" => "Missing email or password"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

$email    = $_POST['email'];
$password = $_POST['password'];
$table1   = isset($_POST['table1']) ? $_POST['table1'] : null;
$table2   = isset($_POST['table2']) ? $_POST['table2'] : null;
$action   = isset($_POST['action']) ? $_POST['action'] : null;
$page     = isset($_POST['page']) ? (int)$_POST['page'] : 0;

$limit  = 100;
$offset = 0;
$pagination_sql = "";

if ($page > 0) {
    $offset = ($page - 1) * $limit;
    $pagination_sql = " LIMIT ? OFFSET ?";
}

$auth_stmt = $conn->prepare("SELECT 1 FROM users WHERE email = ? AND password = ?");
$auth_stmt->bind_param("ss", $email, $password);
$auth_stmt->execute();
$auth_result = $auth_stmt->get_result();
if ($auth_result->num_rows === 0) {
    http_response_code(403);
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}
$auth_stmt->close();

$allowed_tables = ['freefire', 'ludoking', 'joiners'];
$data = [];

function user_joined($conn, $email, $match_id) {
    $q = "SELECT 1 FROM joiners WHERE email = ? AND match_id = ? LIMIT 1";
    $stmt = $conn->prepare($q);
    $stmt->bind_param("ss", $email, $match_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $joined = $res->num_rows > 0;
    $stmt->close();
    return $joined;
}

function filter_room_details($conn, $email, &$rows) {
    foreach ($rows as &$row) {
        $match_id = isset($row['id']) ? $row['id'] : (isset($row['match_id']) ? $row['match_id'] : null);
        if ($match_id && !user_joined($conn, $email, $match_id)) {
            if (isset($row['room_details'])) {
                $row['room_details'] = 'Hide by Rs Captain';
            }
        }
    }
}

if ($action === 'result') {
    $ff_cols = ['id','match_title','match_time','total_prize','entry_fee','entry_type','match_type','play_map','registration','prize_details','total_player','total_joiner','match_result','room_details', 'per_kill', 'version'];
    $lk_cols = ['id','match_title','match_time','total_prize','entry_fee','entry_type','match_type','play_map','registration','prize_details','total_player','total_joiner','match_result','room_details'];

    $all_cols = array_unique(array_merge($ff_cols,$lk_cols));
    $select_ff = [];
    $select_lk = [];

    foreach($all_cols as $col){
        if(in_array($col,$ff_cols)){
            $select_ff[] = "`$col`";
        } else {
            $select_ff[] = "NULL AS `$col`";
        }

        if(in_array($col,$lk_cols)){
            $select_lk[] = "`$col`";
        } else {
            $select_lk[] = "NULL AS `$col`";
        }
    }

    $sql = "(
        SELECT ".implode(",", $select_ff).", 'freefire' AS game_source
        FROM freefire
        WHERE match_result='YES'
    )
    UNION ALL
    (
        SELECT ".implode(",", $select_lk).", 'ludoking' AS game_source
        FROM ludoking
        WHERE match_result='YES'
    )
    ORDER BY id DESC" . $pagination_sql;

    $stmt = $conn->prepare($sql);
    if ($page > 0) {
        $stmt->bind_param("ii",$limit,$offset);
    }
    $stmt->execute();
    $res = $stmt->get_result();
    $rows = $res->fetch_all(MYSQLI_ASSOC);
    filter_room_details($conn, $email, $rows);
    $data['Result'] = $rows;
    $stmt->close();
}

if ($table1) {
    if (in_array($table1, $allowed_tables)) {
        $sql1 = "SELECT * FROM `$table1` ORDER BY id DESC" . $pagination_sql;
        $stmt1 = $conn->prepare($sql1);
        if ($page > 0) {
            $stmt1->bind_param("ii", $limit, $offset);
        }
        $stmt1->execute();
        $res1 = $stmt1->get_result();
        $rows1 = $res1->fetch_all(MYSQLI_ASSOC);
        if ($table1 === 'freefire' || $table1 === 'ludoking') {
            filter_room_details($conn, $email, $rows1);
        }
        $data[$table1] = $rows1;
        $stmt1->close();
    } else {
        $data[$table1] = ["error" => "Access Denied"];
    }
}

if ($table2) {
    if (in_array($table2, $allowed_tables)) {
        $sql2 = "SELECT * FROM `$table2` ORDER BY id DESC" . $pagination_sql;
        $stmt2 = $conn->prepare($sql2);
        if ($page > 0) {
            $stmt2->bind_param("ii", $limit, $offset);
        }
        $stmt2->execute();
        $res2 = $stmt2->get_result();
        $rows2 = $res2->fetch_all(MYSQLI_ASSOC);
        if ($table2 === 'freefire' || $table2 === 'ludoking') {
            filter_room_details($conn, $email, $rows2);
        }
        $data[$table2] = $rows2;
        $stmt2->close();
    } else {
        $data[$table2] = ["error" => "Access Denied"];
    }
}

echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
$conn->close();
?>